# LX Navigation zeus simulation

var zeus_main = nil;
var zeus_start = nil;
var zeus_init = nil;
var zeus_display = nil;

var state = 0;

var zeus_p = props.globals.initNode("/instrumentation/zeus");

var ballast = zeus_p.initNode("ballast-setting-kg", 0, "INT");

var instrument_path = "Aircraft/Phoenix/Models/Instruments/Zeus/";

var volts		= props.globals.getNode("/systems/electrical/outputs/instruments", 1);

var time_hr		=	props.globals.getNode("/sim/time/utc/hour", 1);
var time_min	=	props.globals.getNode("/sim/time/utc/minute", 1);

var wind_deg	=	props.globals.getNode("/environment/wind-from-heading-deg", 1);
var wind_kt		=	props.globals.getNode("/environment/wind-speed-kt",	1);

# Communication to Eos 80 (irl: via CAN-bus)
var vario_te	=	props.globals.getNode("/instrumentation/eos/te-reading-mps", 1);
var vario_av	=	props.globals.getNode("/instrumentation/eos/average-reading-mps", 1);
var vario_nt	=	0.0;

var alti_qnh	=	props.globals.getNode("/instrumentation/eos-altimeter/setting-hpa", 1);
var alti_ft		=	props.globals.getNode("/instrumentation/eos-altimeter/indicated-altitude-ft", 1);

var ias_kt		=	props.globals.getNode("/instrumentation/eos-airspeed-indicator/indicated-speed-kt", 1);
var tas_kt		=	props.globals.getNode("/instrumentation/eos-airspeed-indicator/true-speed-kt", 1);

var alt_agl	=	props.globals.getNode("/position/altitude-agl-ft", 	1);
var alt_gps	=	props.globals.getNode("/position/altitude-ft", 		1);

var gs_kt	=	props.globals.getNode("/velocities/groundspeed-kt", 	1);

var hdg_trk	=	props.globals.getNode("/orientation/track-deg",		1);
var hdg_true	=	props.globals.getNode("/orientation/heading-deg",	1);

var polar_def = [ -0.000997169190256748, 0.19882060566162, -13.4837656352864 ]; # see src/performance_calc.ods

var canvas_zeus_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			if ( weight == "bold" ) {
				return "LiberationFonts/LiberationSans-Bold.ttf";
			} else {
				return "LiberationFonts/LiberationSans-Regular.ttf";
			}
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = volts.getValue();
		if( volt > 9 ){
			if( state == 3 ){
				zeus_main.show();
				zeus_main.update();
				zeus_start.page.hide();
				zeus_init.page.hide();
			} elsif( state == 2 ){
				zeus_main.hide();
				zeus_start.page.hide();
				zeus_init.page.show();
			} elsif( state == 1 ){
				zeus_main.hide();
				zeus_start.page.show();
				zeus_init.page.hide();
			} else {
				state = 1;
			}
		} else {
			zeus_main.hide();;
			zeus_start.page.hide();
			zeus_init.page.hide();
		}
	},
};


var canvas_zeus_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_zeus_start , canvas_zeus_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	
};

var canvas_zeus_init = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_zeus_init , canvas_zeus_base] };
		m.init(canvas_group, file);
		m.active_selection = 0;

		return m;
	},
	getKeys: func() {
		return [ "qnh.active", "qnh.active.text", "qnh.passive", "ballast.active", "ballast.active.text", "ballast.passive" ];
	},
	update: func() {
		if( me.active_selection < 2 ){
			me.active_selection = 2; # skip pilot and elevation selection for now
			me.update();
		} elsif( me.active_selection == 2 ){
			me["qnh.active"].show();
			me["qnh.passive"].hide();
			me["qnh.active.text"].setText( sprintf("%4d", math.round( alti_qnh.getDoubleValue() ) ) ~ "hPa" );
			me["ballast.active"].hide();
			me["ballast.passive"].show();
			me["ballast.passive"].setText( sprintf("%3d", ballast.getIntValue() ) ~ "kg");
		} elsif( me.active_selection == 3 ){
			me.active_selection = 4; # skip polar selection for now
			me.update();
		} elsif( me.active_selection == 4 ){
			me["qnh.active"].hide();
			me["qnh.passive"].show();
			me["qnh.passive"].setText( sprintf("%4d", math.round( alti_qnh.getDoubleValue() ) ) ~ "hPa" );
			me["ballast.active"].show();
			me["ballast.active.text"].setText( sprintf("%3d", ballast.getIntValue() ) ~ "kg");
			me["ballast.passive"].hide();
		}
	},
};


var ls = setlistener("sim/signals/fdm-initialized", func {
	zeus_display = canvas.new({
		"name": "zeus",
		"size": [480, 640],
		"view": [480, 640],
		"mipmapping": 1
	});
	zeus_display.addPlacement({"node": "zeus.display"});
	
	zeus_main = canvas_nd.new( zeus_display.createGroup() );
	
	zeus_start = canvas_zeus_start.new(zeus_display.createGroup(), instrument_path~"zeus_start.svg");
	zeus_init = canvas_zeus_init.new(zeus_display.createGroup(), instrument_path~"zeus_init.svg");
	
	var base_update = maketimer(0.2, func() {
				canvas_zeus_base.update();
			});
	base_update.start();
	removelistener(ls);
});

setlistener(volts, func{
	if(volts.getValue() >= 10 and state == 0 ){
		state = 1;
		settimer( func{
			state = 2;
			zeus_init.update();
		}, 0.7 + rand() * 0.5 );
	}else if( volts.getValue() < 10 ){
		state = 0;
	}
});


var range_settings = [ 1, 2.5, 5, 10, 25, 50, 100, 200 ]; # km (fifth circle)
var x = 4;

var left_knob = [
	func( i ){
	},
	func{},
];
var right_knob = [
	func( i ){
		if( state == 3 ){
			x += i;
			if( x < 0 ) x = 0;
			if( x > 7 ) x = 7;
			zeus_main.map.setRange( range_settings[ x ] * 300 / 520 );
			zeus_main.on_range_change();
		} elsif( state == 2 ){
			if( zeus_init.active_selection == 2 ){
				# set QNH
				alti_qnh.setDoubleValue( alti_qnh.getDoubleValue() + i );
			} elsif( zeus_init.active_selection == 4 ){
				# set ballast
				ballast.setIntValue( ballast.getIntValue() + i );
				if( ballast.getIntValue() < 0 ) ballast.setIntValue( 0 );
			}
			zeus_init.update();
		}
	},
	func{
		if( state == 2 ){
			zeus_init.active_selection += 1;
			if( zeus_init.active_selection > 4 ){
				state = 3;
				zeus_init.active_selection = 0;
			}
			zeus_init.update();
		}
	},
];
