/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "JSDOMWindowBase.h"
#include "JSDOMWrapper.h"

namespace WebCore {

class LocalDOMWindow;

class JSWindowProxy;

class WEBCORE_EXPORT JSLocalDOMWindow : public JSDOMWindowBase {
public:
    using Base = JSDOMWindowBase;
    using DOMWrapped = LocalDOMWindow;
    static JSLocalDOMWindow* create(JSC::VM& vm, JSC::Structure* structure, Ref<LocalDOMWindow>&& impl, JSWindowProxy* proxy)
    {
        JSLocalDOMWindow* ptr = new (NotNull, JSC::allocateCell<JSLocalDOMWindow>(vm)) JSLocalDOMWindow(vm, structure, WTFMove(impl), proxy);
        ptr->finishCreation(vm, proxy);
        return ptr;
    }

    static LocalDOMWindow* toWrapped(JSC::VM&, JSC::JSValue);
    static bool getOwnPropertySlot(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertySlotByIndex(JSC::JSObject*, JSC::JSGlobalObject*, unsigned propertyName, JSC::PropertySlot&);
    static void getOwnPropertyNames(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyNameArray&, JSC::DontEnumPropertiesMode);
    static bool put(JSC::JSCell*, JSC::JSGlobalObject*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static bool putByIndex(JSC::JSCell*, JSC::JSGlobalObject*, unsigned propertyName, JSC::JSValue, bool shouldThrow);
    static bool defineOwnProperty(JSC::JSObject*, JSC::JSGlobalObject*, JSC::PropertyName, const JSC::PropertyDescriptor&, bool shouldThrow);
    static bool deleteProperty(JSC::JSCell*, JSC::JSGlobalObject*, JSC::PropertyName, JSC::DeletePropertySlot&);
    static bool deletePropertyByIndex(JSC::JSCell*, JSC::JSGlobalObject*, unsigned);
    static JSC::JSValue getPrototype(JSC::JSObject*, JSC::JSGlobalObject*);
    static bool preventExtensions(JSC::JSObject*, JSC::JSGlobalObject*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::GlobalObjectType, StructureFlags), info(), JSC::MayHaveIndexedAccessors);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    DECLARE_VISIT_CHILDREN;
    template<typename Visitor> void visitAdditionalChildren(Visitor&);

    template<typename Visitor> static void visitOutputConstraints(JSCell*, Visitor&);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);

    // Custom attributes
    JSC::JSValue window(JSC::JSGlobalObject&) const;
    JSC::JSValue self(JSC::JSGlobalObject&) const;
    JSC::JSValue frames(JSC::JSGlobalObject&) const;
    void setOpener(JSC::JSGlobalObject&, JSC::JSValue);
    JSC::JSValue event(JSC::JSGlobalObject&) const;
    JSC::JSValue openDatabase(JSC::JSGlobalObject&) const;
    void setOpenDatabase(JSC::JSGlobalObject&, JSC::JSValue);

    // Custom functions
    JSC::JSValue queueMicrotask(JSC::JSGlobalObject&, JSC::CallFrame&);
    LocalDOMWindow& wrapped() const
    {
        return static_cast<LocalDOMWindow&>(Base::wrapped());
    }
public:
    static constexpr unsigned StructureFlags = Base::StructureFlags | JSC::HasStaticPropertyTable | JSC::ImplementsHasInstance | JSC::ImplementsDefaultHasInstance | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::IsImmutablePrototypeExoticObject | JSC::OverridesGetOwnPropertyNames | JSC::OverridesGetOwnPropertySlot | JSC::OverridesGetPrototype | JSC::OverridesPut;
protected:
    JSLocalDOMWindow(JSC::VM&, JSC::Structure*, Ref<LocalDOMWindow>&&, JSWindowProxy*);
    void finishCreation(JSC::VM&, JSWindowProxy*);
};


class JSLocalDOMWindowPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSLocalDOMWindowPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSLocalDOMWindowPrototype* ptr = new (NotNull, JSC::allocateCell<JSLocalDOMWindowPrototype>(vm)) JSLocalDOMWindowPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSLocalDOMWindowPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSLocalDOMWindowPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
public:
    static constexpr unsigned StructureFlags = Base::StructureFlags | JSC::HasStaticPropertyTable | JSC::IsImmutablePrototypeExoticObject;
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSLocalDOMWindowPrototype, JSLocalDOMWindowPrototype::Base);

template<> struct JSDOMWrapperConverterTraits<LocalDOMWindow> {
    using WrapperClass = JSLocalDOMWindow;
    using ToWrappedReturnType = LocalDOMWindow*;
};

} // namespace WebCore
