// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyRubyPosition = 3,
    CSSPropertyWritingMode = 4,
    CSSPropertyDirection = 5,
    CSSPropertyDisplay = 6,
    CSSPropertyFontFamily = 7,
    CSSPropertyFontFeatureSettings = 8,
    CSSPropertyFontKerning = 9,
    CSSPropertyFontOpticalSizing = 10,
    CSSPropertyFontPalette = 11,
    CSSPropertyFontSize = 12,
    CSSPropertyFontSizeAdjust = 13,
    CSSPropertyFontStyle = 14,
    CSSPropertyFontSynthesisSmallCaps = 15,
    CSSPropertyFontSynthesisStyle = 16,
    CSSPropertyFontSynthesisWeight = 17,
    CSSPropertyFontVariantAlternates = 18,
    CSSPropertyFontVariantCaps = 19,
    CSSPropertyFontVariantEastAsian = 20,
    CSSPropertyFontVariantEmoji = 21,
    CSSPropertyFontVariantLigatures = 22,
    CSSPropertyFontVariantNumeric = 23,
    CSSPropertyFontVariantPosition = 24,
    CSSPropertyFontVariationSettings = 25,
    CSSPropertyFontWeight = 26,
    CSSPropertyFontWidth = 27,
    CSSPropertyTextOrientation = 28,
    CSSPropertyTextRendering = 29,
    CSSPropertyZoom = 30,
    CSSPropertyWebkitFontSmoothing = 31,
    CSSPropertyWebkitLocale = 32,
    CSSPropertyWebkitTextSizeAdjust = 33,
    CSSPropertyWebkitTextZoom = 34,
    CSSPropertyLetterSpacing = 35,
    CSSPropertyTextAutospace = 36,
    CSSPropertyTextSpacingTrim = 37,
    CSSPropertyAccentColor = 38,
    CSSPropertyAdditiveSymbols = 39,
    CSSPropertyAlignContent = 40,
    CSSPropertyAlignItems = 41,
    CSSPropertyAlignSelf = 42,
    CSSPropertyAlignmentBaseline = 43,
    CSSPropertyAnchorName = 44,
    CSSPropertyAnchorScope = 45,
    CSSPropertyAnimationComposition = 46,
    CSSPropertyAnimationDelay = 47,
    CSSPropertyAnimationDirection = 48,
    CSSPropertyAnimationDuration = 49,
    CSSPropertyAnimationFillMode = 50,
    CSSPropertyAnimationIterationCount = 51,
    CSSPropertyAnimationName = 52,
    CSSPropertyAnimationPlayState = 53,
    CSSPropertyAnimationRangeEnd = 54,
    CSSPropertyAnimationRangeStart = 55,
    CSSPropertyAnimationTimeline = 56,
    CSSPropertyAnimationTimingFunction = 57,
    CSSPropertyAppearance = 58,
    CSSPropertyAspectRatio = 59,
    CSSPropertyBackdropFilter = 60,
    CSSPropertyBackfaceVisibility = 61,
    CSSPropertyBackgroundAttachment = 62,
    CSSPropertyBackgroundBlendMode = 63,
    CSSPropertyBackgroundClip = 64,
    CSSPropertyBackgroundColor = 65,
    CSSPropertyBackgroundImage = 66,
    CSSPropertyBackgroundOrigin = 67,
    CSSPropertyBackgroundPositionX = 68,
    CSSPropertyBackgroundPositionY = 69,
    CSSPropertyBackgroundRepeat = 70,
    CSSPropertyBackgroundSize = 71,
    CSSPropertyBasePalette = 72,
    CSSPropertyBaselineShift = 73,
    CSSPropertyBlockEllipsis = 74,
    CSSPropertyBlockStepAlign = 75,
    CSSPropertyBlockStepInsert = 76,
    CSSPropertyBlockStepRound = 77,
    CSSPropertyBlockStepSize = 78,
    CSSPropertyBorderCollapse = 79,
    CSSPropertyBorderImageOutset = 80,
    CSSPropertyBorderImageRepeat = 81,
    CSSPropertyBorderImageSlice = 82,
    CSSPropertyBorderImageSource = 83,
    CSSPropertyBorderImageWidth = 84,
    CSSPropertyBoxShadow = 85,
    CSSPropertyBoxSizing = 86,
    CSSPropertyBreakAfter = 87,
    CSSPropertyBreakBefore = 88,
    CSSPropertyBreakInside = 89,
    CSSPropertyBufferedRendering = 90,
    CSSPropertyCaptionSide = 91,
    CSSPropertyCaretColor = 92,
    CSSPropertyClear = 93,
    CSSPropertyClip = 94,
    CSSPropertyClipPath = 95,
    CSSPropertyClipRule = 96,
    CSSPropertyColor = 97,
    CSSPropertyColorInterpolation = 98,
    CSSPropertyColorInterpolationFilters = 99,
    CSSPropertyColumnCount = 100,
    CSSPropertyColumnFill = 101,
    CSSPropertyColumnGap = 102,
    CSSPropertyColumnRuleColor = 103,
    CSSPropertyColumnRuleStyle = 104,
    CSSPropertyColumnRuleWidth = 105,
    CSSPropertyColumnSpan = 106,
    CSSPropertyColumnWidth = 107,
    CSSPropertyContain = 108,
    CSSPropertyContainerName = 109,
    CSSPropertyContainerType = 110,
    CSSPropertyContent = 111,
    CSSPropertyContentVisibility = 112,
    CSSPropertyContinue = 113,
    CSSPropertyCounterIncrement = 114,
    CSSPropertyCounterReset = 115,
    CSSPropertyCounterSet = 116,
    CSSPropertyCursor = 117,
    CSSPropertyCx = 118,
    CSSPropertyCy = 119,
    CSSPropertyD = 120,
    CSSPropertyDominantBaseline = 121,
    CSSPropertyDynamicRangeLimit = 122,
    CSSPropertyEmptyCells = 123,
    CSSPropertyFallback = 124,
    CSSPropertyFieldSizing = 125,
    CSSPropertyFill = 126,
    CSSPropertyFillOpacity = 127,
    CSSPropertyFillRule = 128,
    CSSPropertyFilter = 129,
    CSSPropertyFlexBasis = 130,
    CSSPropertyFlexDirection = 131,
    CSSPropertyFlexGrow = 132,
    CSSPropertyFlexShrink = 133,
    CSSPropertyFlexWrap = 134,
    CSSPropertyFloat = 135,
    CSSPropertyFloodColor = 136,
    CSSPropertyFloodOpacity = 137,
    CSSPropertyFontDisplay = 138,
    CSSPropertyGlyphOrientationHorizontal = 139,
    CSSPropertyGlyphOrientationVertical = 140,
    CSSPropertyGridAutoColumns = 141,
    CSSPropertyGridAutoFlow = 142,
    CSSPropertyGridAutoRows = 143,
    CSSPropertyGridColumnEnd = 144,
    CSSPropertyGridColumnStart = 145,
    CSSPropertyGridRowEnd = 146,
    CSSPropertyGridRowStart = 147,
    CSSPropertyGridTemplateAreas = 148,
    CSSPropertyGridTemplateColumns = 149,
    CSSPropertyGridTemplateRows = 150,
    CSSPropertyHangingPunctuation = 151,
    CSSPropertyHyphenateCharacter = 152,
    CSSPropertyHyphens = 153,
    CSSPropertyImageOrientation = 154,
    CSSPropertyImageRendering = 155,
    CSSPropertyInherits = 156,
    CSSPropertyInitialValue = 157,
    CSSPropertyInputSecurity = 158,
    CSSPropertyIsolation = 159,
    CSSPropertyJustifyContent = 160,
    CSSPropertyJustifyItems = 161,
    CSSPropertyJustifySelf = 162,
    CSSPropertyLightingColor = 163,
    CSSPropertyLineBreak = 164,
    CSSPropertyLineFitEdge = 165,
    CSSPropertyLineHeight = 166,
    CSSPropertyListStyleImage = 167,
    CSSPropertyListStylePosition = 168,
    CSSPropertyListStyleType = 169,
    CSSPropertyMarginTrim = 170,
    CSSPropertyMarkerEnd = 171,
    CSSPropertyMarkerMid = 172,
    CSSPropertyMarkerStart = 173,
    CSSPropertyMaskBorderOutset = 174,
    CSSPropertyMaskBorderRepeat = 175,
    CSSPropertyMaskBorderSlice = 176,
    CSSPropertyMaskBorderSource = 177,
    CSSPropertyMaskBorderWidth = 178,
    CSSPropertyMaskClip = 179,
    CSSPropertyMaskComposite = 180,
    CSSPropertyMaskImage = 181,
    CSSPropertyMaskMode = 182,
    CSSPropertyMaskOrigin = 183,
    CSSPropertyMaskRepeat = 184,
    CSSPropertyMaskSize = 185,
    CSSPropertyMaskType = 186,
    CSSPropertyMathShift = 187,
    CSSPropertyMathStyle = 188,
    CSSPropertyMaxLines = 189,
    CSSPropertyMixBlendMode = 190,
    CSSPropertyNavigation = 191,
    CSSPropertyNegative = 192,
    CSSPropertyObjectFit = 193,
    CSSPropertyObjectPosition = 194,
    CSSPropertyOffsetAnchor = 195,
    CSSPropertyOffsetDistance = 196,
    CSSPropertyOffsetPath = 197,
    CSSPropertyOffsetPosition = 198,
    CSSPropertyOffsetRotate = 199,
    CSSPropertyOpacity = 200,
    CSSPropertyOrder = 201,
    CSSPropertyOrphans = 202,
    CSSPropertyOutlineColor = 203,
    CSSPropertyOutlineOffset = 204,
    CSSPropertyOutlineStyle = 205,
    CSSPropertyOutlineWidth = 206,
    CSSPropertyOverflowAnchor = 207,
    CSSPropertyOverflowWrap = 208,
    CSSPropertyOverrideColors = 209,
    CSSPropertyPad = 210,
    CSSPropertyPage = 211,
    CSSPropertyPaintOrder = 212,
    CSSPropertyPerspective = 213,
    CSSPropertyPerspectiveOriginX = 214,
    CSSPropertyPerspectiveOriginY = 215,
    CSSPropertyPointerEvents = 216,
    CSSPropertyPosition = 217,
    CSSPropertyPositionAnchor = 218,
    CSSPropertyPositionArea = 219,
    CSSPropertyPositionTryFallbacks = 220,
    CSSPropertyPositionTryOrder = 221,
    CSSPropertyPositionVisibility = 222,
    CSSPropertyPrefix = 223,
    CSSPropertyPrintColorAdjust = 224,
    CSSPropertyQuotes = 225,
    CSSPropertyR = 226,
    CSSPropertyRange = 227,
    CSSPropertyResize = 228,
    CSSPropertyRotate = 229,
    CSSPropertyRowGap = 230,
    CSSPropertyRubyAlign = 231,
    CSSPropertyRubyOverhang = 232,
    CSSPropertyRx = 233,
    CSSPropertyRy = 234,
    CSSPropertyScale = 235,
    CSSPropertyScrollBehavior = 236,
    CSSPropertyScrollSnapAlign = 237,
    CSSPropertyScrollSnapStop = 238,
    CSSPropertyScrollSnapType = 239,
    CSSPropertyScrollTimelineAxis = 240,
    CSSPropertyScrollTimelineName = 241,
    CSSPropertyScrollbarColor = 242,
    CSSPropertyScrollbarGutter = 243,
    CSSPropertyScrollbarWidth = 244,
    CSSPropertyShapeImageThreshold = 245,
    CSSPropertyShapeMargin = 246,
    CSSPropertyShapeOutside = 247,
    CSSPropertyShapeRendering = 248,
    CSSPropertySize = 249,
    CSSPropertySizeAdjust = 250,
    CSSPropertySpeakAs = 251,
    CSSPropertySrc = 252,
    CSSPropertyStopColor = 253,
    CSSPropertyStopOpacity = 254,
    CSSPropertyStroke = 255,
    CSSPropertyStrokeColor = 256,
    CSSPropertyStrokeDasharray = 257,
    CSSPropertyStrokeDashoffset = 258,
    CSSPropertyStrokeLinecap = 259,
    CSSPropertyStrokeLinejoin = 260,
    CSSPropertyStrokeMiterlimit = 261,
    CSSPropertyStrokeOpacity = 262,
    CSSPropertyStrokeWidth = 263,
    CSSPropertySuffix = 264,
    CSSPropertySymbols = 265,
    CSSPropertySyntax = 266,
    CSSPropertySystem = 267,
    CSSPropertyTabSize = 268,
    CSSPropertyTableLayout = 269,
    CSSPropertyTextAlign = 270,
    CSSPropertyTextAlignLast = 271,
    CSSPropertyTextAnchor = 272,
    CSSPropertyTextBoxEdge = 273,
    CSSPropertyTextBoxTrim = 274,
    CSSPropertyTextCombineUpright = 275,
    CSSPropertyTextDecorationColor = 276,
    CSSPropertyTextDecorationLine = 277,
    CSSPropertyTextDecorationSkipInk = 278,
    CSSPropertyTextDecorationStyle = 279,
    CSSPropertyTextDecorationThickness = 280,
    CSSPropertyTextEmphasisColor = 281,
    CSSPropertyTextEmphasisPosition = 282,
    CSSPropertyTextEmphasisStyle = 283,
    CSSPropertyTextGroupAlign = 284,
    CSSPropertyTextIndent = 285,
    CSSPropertyTextJustify = 286,
    CSSPropertyTextOverflow = 287,
    CSSPropertyTextShadow = 288,
    CSSPropertyTextTransform = 289,
    CSSPropertyTextUnderlineOffset = 290,
    CSSPropertyTextUnderlinePosition = 291,
    CSSPropertyTextWrapMode = 292,
    CSSPropertyTextWrapStyle = 293,
    CSSPropertyTimelineScope = 294,
    CSSPropertyTouchAction = 295,
    CSSPropertyTransform = 296,
    CSSPropertyTransformBox = 297,
    CSSPropertyTransformOriginX = 298,
    CSSPropertyTransformOriginY = 299,
    CSSPropertyTransformOriginZ = 300,
    CSSPropertyTransformStyle = 301,
    CSSPropertyTransitionBehavior = 302,
    CSSPropertyTransitionDelay = 303,
    CSSPropertyTransitionDuration = 304,
    CSSPropertyTransitionProperty = 305,
    CSSPropertyTransitionTimingFunction = 306,
    CSSPropertyTranslate = 307,
    CSSPropertyTypes = 308,
    CSSPropertyUnicodeBidi = 309,
    CSSPropertyUnicodeRange = 310,
    CSSPropertyVectorEffect = 311,
    CSSPropertyVerticalAlign = 312,
    CSSPropertyViewTimelineAxis = 313,
    CSSPropertyViewTimelineInset = 314,
    CSSPropertyViewTimelineName = 315,
    CSSPropertyViewTransitionClass = 316,
    CSSPropertyViewTransitionName = 317,
    CSSPropertyVisibility = 318,
    CSSPropertyWhiteSpaceCollapse = 319,
    CSSPropertyWidows = 320,
    CSSPropertyWillChange = 321,
    CSSPropertyWordBreak = 322,
    CSSPropertyX = 323,
    CSSPropertyY = 324,
    CSSPropertyZIndex = 325,
    CSSPropertyAppleColorFilter = 326,
    CSSPropertyApplePayButtonStyle = 327,
    CSSPropertyApplePayButtonType = 328,
    CSSPropertyAppleVisualEffect = 329,
    CSSPropertyInternalTextAutosizingStatus = 330,
    CSSPropertyWebkitBackdropFilter = 331,
    CSSPropertyWebkitBackgroundClip = 332,
    CSSPropertyWebkitBackgroundOrigin = 333,
    CSSPropertyWebkitBorderHorizontalSpacing = 334,
    CSSPropertyWebkitBorderVerticalSpacing = 335,
    CSSPropertyWebkitBoxAlign = 336,
    CSSPropertyWebkitBoxDecorationBreak = 337,
    CSSPropertyWebkitBoxDirection = 338,
    CSSPropertyWebkitBoxFlex = 339,
    CSSPropertyWebkitBoxFlexGroup = 340,
    CSSPropertyWebkitBoxLines = 341,
    CSSPropertyWebkitBoxOrdinalGroup = 342,
    CSSPropertyWebkitBoxOrient = 343,
    CSSPropertyWebkitBoxPack = 344,
    CSSPropertyWebkitBoxReflect = 345,
    CSSPropertyWebkitBoxShadow = 346,
    CSSPropertyWebkitColumnAxis = 347,
    CSSPropertyWebkitColumnProgression = 348,
    CSSPropertyWebkitCursorVisibility = 349,
    CSSPropertyWebkitFontSizeDelta = 350,
    CSSPropertyWebkitHyphenateLimitAfter = 351,
    CSSPropertyWebkitHyphenateLimitBefore = 352,
    CSSPropertyWebkitHyphenateLimitLines = 353,
    CSSPropertyWebkitInitialLetter = 354,
    CSSPropertyWebkitLineAlign = 355,
    CSSPropertyWebkitLineBoxContain = 356,
    CSSPropertyWebkitLineClamp = 357,
    CSSPropertyWebkitLineGrid = 358,
    CSSPropertyWebkitLineSnap = 359,
    CSSPropertyWebkitMarqueeDirection = 360,
    CSSPropertyWebkitMarqueeIncrement = 361,
    CSSPropertyWebkitMarqueeRepetition = 362,
    CSSPropertyWebkitMarqueeSpeed = 363,
    CSSPropertyWebkitMarqueeStyle = 364,
    CSSPropertyWebkitMaskClip = 365,
    CSSPropertyWebkitMaskComposite = 366,
    CSSPropertyWebkitMaskPositionX = 367,
    CSSPropertyWebkitMaskPositionY = 368,
    CSSPropertyWebkitMaskSourceType = 369,
    CSSPropertyWebkitNbspMode = 370,
    CSSPropertyWebkitRtlOrdering = 371,
    CSSPropertyWebkitRubyPosition = 372,
    CSSPropertyWebkitTapHighlightColor = 373,
    CSSPropertyWebkitTextCombine = 374,
    CSSPropertyWebkitTextDecorationsInEffect = 375,
    CSSPropertyWebkitTextFillColor = 376,
    CSSPropertyWebkitTextSecurity = 377,
    CSSPropertyWebkitTextStrokeColor = 378,
    CSSPropertyWebkitTextStrokeWidth = 379,
    CSSPropertyWebkitUserDrag = 380,
    CSSPropertyWebkitUserModify = 381,
    CSSPropertyWebkitUserSelect = 382,
    CSSPropertyWordSpacing = 383,
    CSSPropertyBorderBottomColor = 384,
    CSSPropertyBorderBottomLeftRadius = 385,
    CSSPropertyBorderBottomRightRadius = 386,
    CSSPropertyBorderBottomStyle = 387,
    CSSPropertyBorderBottomWidth = 388,
    CSSPropertyBorderLeftColor = 389,
    CSSPropertyBorderLeftStyle = 390,
    CSSPropertyBorderLeftWidth = 391,
    CSSPropertyBorderRightColor = 392,
    CSSPropertyBorderRightStyle = 393,
    CSSPropertyBorderRightWidth = 394,
    CSSPropertyBorderTopColor = 395,
    CSSPropertyBorderTopLeftRadius = 396,
    CSSPropertyBorderTopRightRadius = 397,
    CSSPropertyBorderTopStyle = 398,
    CSSPropertyBorderTopWidth = 399,
    CSSPropertyBottom = 400,
    CSSPropertyContainIntrinsicHeight = 401,
    CSSPropertyContainIntrinsicWidth = 402,
    CSSPropertyCornerBottomLeftShape = 403,
    CSSPropertyCornerBottomRightShape = 404,
    CSSPropertyCornerTopLeftShape = 405,
    CSSPropertyCornerTopRightShape = 406,
    CSSPropertyHeight = 407,
    CSSPropertyLeft = 408,
    CSSPropertyMarginBottom = 409,
    CSSPropertyMarginLeft = 410,
    CSSPropertyMarginRight = 411,
    CSSPropertyMarginTop = 412,
    CSSPropertyMaxHeight = 413,
    CSSPropertyMaxWidth = 414,
    CSSPropertyMinHeight = 415,
    CSSPropertyMinWidth = 416,
    CSSPropertyOverflowX = 417,
    CSSPropertyOverflowY = 418,
    CSSPropertyOverscrollBehaviorX = 419,
    CSSPropertyOverscrollBehaviorY = 420,
    CSSPropertyPaddingBottom = 421,
    CSSPropertyPaddingLeft = 422,
    CSSPropertyPaddingRight = 423,
    CSSPropertyPaddingTop = 424,
    CSSPropertyRight = 425,
    CSSPropertyScrollMarginBottom = 426,
    CSSPropertyScrollMarginLeft = 427,
    CSSPropertyScrollMarginRight = 428,
    CSSPropertyScrollMarginTop = 429,
    CSSPropertyScrollPaddingBottom = 430,
    CSSPropertyScrollPaddingLeft = 431,
    CSSPropertyScrollPaddingRight = 432,
    CSSPropertyScrollPaddingTop = 433,
    CSSPropertyTop = 434,
    CSSPropertyWidth = 435,
    CSSPropertyBlockSize = 436,
    CSSPropertyBorderBlockEndColor = 437,
    CSSPropertyBorderBlockEndStyle = 438,
    CSSPropertyBorderBlockEndWidth = 439,
    CSSPropertyBorderBlockStartColor = 440,
    CSSPropertyBorderBlockStartStyle = 441,
    CSSPropertyBorderBlockStartWidth = 442,
    CSSPropertyBorderEndEndRadius = 443,
    CSSPropertyBorderEndStartRadius = 444,
    CSSPropertyBorderInlineEndColor = 445,
    CSSPropertyBorderInlineEndStyle = 446,
    CSSPropertyBorderInlineEndWidth = 447,
    CSSPropertyBorderInlineStartColor = 448,
    CSSPropertyBorderInlineStartStyle = 449,
    CSSPropertyBorderInlineStartWidth = 450,
    CSSPropertyBorderStartEndRadius = 451,
    CSSPropertyBorderStartStartRadius = 452,
    CSSPropertyContainIntrinsicBlockSize = 453,
    CSSPropertyContainIntrinsicInlineSize = 454,
    CSSPropertyCornerEndEndShape = 455,
    CSSPropertyCornerEndStartShape = 456,
    CSSPropertyCornerStartEndShape = 457,
    CSSPropertyCornerStartStartShape = 458,
    CSSPropertyInlineSize = 459,
    CSSPropertyInsetBlockEnd = 460,
    CSSPropertyInsetBlockStart = 461,
    CSSPropertyInsetInlineEnd = 462,
    CSSPropertyInsetInlineStart = 463,
    CSSPropertyMarginBlockEnd = 464,
    CSSPropertyMarginBlockStart = 465,
    CSSPropertyMarginInlineEnd = 466,
    CSSPropertyMarginInlineStart = 467,
    CSSPropertyMaxBlockSize = 468,
    CSSPropertyMaxInlineSize = 469,
    CSSPropertyMinBlockSize = 470,
    CSSPropertyMinInlineSize = 471,
    CSSPropertyOverflowBlock = 472,
    CSSPropertyOverflowInline = 473,
    CSSPropertyOverscrollBehaviorBlock = 474,
    CSSPropertyOverscrollBehaviorInline = 475,
    CSSPropertyPaddingBlockEnd = 476,
    CSSPropertyPaddingBlockStart = 477,
    CSSPropertyPaddingInlineEnd = 478,
    CSSPropertyPaddingInlineStart = 479,
    CSSPropertyScrollMarginBlockEnd = 480,
    CSSPropertyScrollMarginBlockStart = 481,
    CSSPropertyScrollMarginInlineEnd = 482,
    CSSPropertyScrollMarginInlineStart = 483,
    CSSPropertyScrollPaddingBlockEnd = 484,
    CSSPropertyScrollPaddingBlockStart = 485,
    CSSPropertyScrollPaddingInlineEnd = 486,
    CSSPropertyScrollPaddingInlineStart = 487,
    CSSPropertyAll = 488,
    CSSPropertyAnimation = 489,
    CSSPropertyAnimationRange = 490,
    CSSPropertyBackground = 491,
    CSSPropertyBackgroundPosition = 492,
    CSSPropertyBlockStep = 493,
    CSSPropertyBorder = 494,
    CSSPropertyBorderBlock = 495,
    CSSPropertyBorderBlockColor = 496,
    CSSPropertyBorderBlockEnd = 497,
    CSSPropertyBorderBlockStart = 498,
    CSSPropertyBorderBlockStyle = 499,
    CSSPropertyBorderBlockWidth = 500,
    CSSPropertyBorderBottom = 501,
    CSSPropertyBorderColor = 502,
    CSSPropertyBorderImage = 503,
    CSSPropertyBorderInline = 504,
    CSSPropertyBorderInlineColor = 505,
    CSSPropertyBorderInlineEnd = 506,
    CSSPropertyBorderInlineStart = 507,
    CSSPropertyBorderInlineStyle = 508,
    CSSPropertyBorderInlineWidth = 509,
    CSSPropertyBorderLeft = 510,
    CSSPropertyBorderRadius = 511,
    CSSPropertyBorderRight = 512,
    CSSPropertyBorderSpacing = 513,
    CSSPropertyBorderStyle = 514,
    CSSPropertyBorderTop = 515,
    CSSPropertyBorderWidth = 516,
    CSSPropertyColumnRule = 517,
    CSSPropertyColumns = 518,
    CSSPropertyContainIntrinsicSize = 519,
    CSSPropertyContainer = 520,
    CSSPropertyCornerShape = 521,
    CSSPropertyFlex = 522,
    CSSPropertyFlexFlow = 523,
    CSSPropertyFont = 524,
    CSSPropertyFontSynthesis = 525,
    CSSPropertyFontVariant = 526,
    CSSPropertyGap = 527,
    CSSPropertyGrid = 528,
    CSSPropertyGridArea = 529,
    CSSPropertyGridColumn = 530,
    CSSPropertyGridRow = 531,
    CSSPropertyGridTemplate = 532,
    CSSPropertyInset = 533,
    CSSPropertyInsetBlock = 534,
    CSSPropertyInsetInline = 535,
    CSSPropertyLineClamp = 536,
    CSSPropertyListStyle = 537,
    CSSPropertyMargin = 538,
    CSSPropertyMarginBlock = 539,
    CSSPropertyMarginInline = 540,
    CSSPropertyMarker = 541,
    CSSPropertyMask = 542,
    CSSPropertyMaskBorder = 543,
    CSSPropertyMaskPosition = 544,
    CSSPropertyOffset = 545,
    CSSPropertyOutline = 546,
    CSSPropertyOverflow = 547,
    CSSPropertyOverscrollBehavior = 548,
    CSSPropertyPadding = 549,
    CSSPropertyPaddingBlock = 550,
    CSSPropertyPaddingInline = 551,
    CSSPropertyPageBreakAfter = 552,
    CSSPropertyPageBreakBefore = 553,
    CSSPropertyPageBreakInside = 554,
    CSSPropertyPerspectiveOrigin = 555,
    CSSPropertyPlaceContent = 556,
    CSSPropertyPlaceItems = 557,
    CSSPropertyPlaceSelf = 558,
    CSSPropertyPositionTry = 559,
    CSSPropertyScrollMargin = 560,
    CSSPropertyScrollMarginBlock = 561,
    CSSPropertyScrollMarginInline = 562,
    CSSPropertyScrollPadding = 563,
    CSSPropertyScrollPaddingBlock = 564,
    CSSPropertyScrollPaddingInline = 565,
    CSSPropertyScrollTimeline = 566,
    CSSPropertyTextBox = 567,
    CSSPropertyTextDecoration = 568,
    CSSPropertyTextDecorationSkip = 569,
    CSSPropertyTextEmphasis = 570,
    CSSPropertyTextWrap = 571,
    CSSPropertyTransformOrigin = 572,
    CSSPropertyTransition = 573,
    CSSPropertyViewTimeline = 574,
    CSSPropertyWhiteSpace = 575,
    CSSPropertyWebkitBackgroundSize = 576,
    CSSPropertyWebkitBorderImage = 577,
    CSSPropertyWebkitBorderRadius = 578,
    CSSPropertyWebkitColumnBreakAfter = 579,
    CSSPropertyWebkitColumnBreakBefore = 580,
    CSSPropertyWebkitColumnBreakInside = 581,
    CSSPropertyWebkitMask = 582,
    CSSPropertyWebkitMaskBoxImage = 583,
    CSSPropertyWebkitMaskPosition = 584,
    CSSPropertyWebkitPerspective = 585,
    CSSPropertyWebkitTextOrientation = 586,
    CSSPropertyWebkitTextStroke = 587,
};

// Enum value of the first "real" CSS property, which excludes
// CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t firstCSSProperty = 2;
// Total number of enum values in the CSSPropertyID enum. If making an array
// that can be indexed into using the enum value, use this as the size.
constexpr uint16_t cssPropertyIDEnumValueCount = 588;
// Number of "real" CSS properties. This differs from cssPropertyIDEnumValueCount,
// as this doesn't consider CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t numCSSProperties = 586;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWritingMode;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyDirection;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyTextSpacingTrim;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWordSpacing;
constexpr auto firstLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyBorderBottomColor;
constexpr auto lastLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyWidth;
constexpr auto firstLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyBlockSize;
constexpr auto lastLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyScrollPaddingInlineStart;
constexpr auto firstLogicalGroupProperty = firstLogicalGroupPhysicalProperty;
constexpr auto lastLogicalGroupProperty = lastLogicalGroupLogicalProperty;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;
extern const std::array<CSSPropertyID, 453> computedPropertyIDs;

struct CSSPropertySettings {
    WTF_DEPRECATED_MAKE_STRUCT_FAST_ALLOCATED(CSSPropertySettings);

    bool accentColorEnabled : 1 { false };
    bool colorFilterEnabled : 1 { false };
    bool crossDocumentViewTransitionsEnabled : 1 { false };
    bool cssAnchorPositioningEnabled : 1 { false };
    bool cssCornerShapeEnabled : 1 { false };
    bool cssDPropertyEnabled : 1 { false };
    bool cssFieldSizingEnabled : 1 { false };
    bool cssFontVariantEmojiEnabled : 1 { false };
    bool cssInputSecurityEnabled : 1 { false };
    bool cssLineClampEnabled : 1 { false };
    bool cssLineFitEdgeEnabled : 1 { false };
    bool cssRhythmicSizingEnabled : 1 { false };
    bool cssRubyAlignEnabled : 1 { false };
    bool cssRubyOverhangEnabled : 1 { false };
    bool cssScrollAnchoringEnabled : 1 { false };
    bool cssScrollbarColorEnabled : 1 { false };
    bool cssScrollbarGutterEnabled : 1 { false };
    bool cssScrollbarWidthEnabled : 1 { false };
    bool cssTextAutospaceEnabled : 1 { false };
    bool cssTextBoxTrimEnabled : 1 { false };
    bool cssTextGroupAlignEnabled : 1 { false };
    bool cssTextJustifyEnabled : 1 { false };
    bool cssTextSpacingTrimEnabled : 1 { false };
    bool cssUnprefixedBackdropFilterEnabled : 1 { false };
    bool overscrollBehaviorEnabled : 1 { false };
    bool scrollDrivenAnimationsEnabled : 1 { false };
    bool supportHDRDisplayEnabled : 1 { false };
    bool textAutosizingEnabled : 1 { false };
    bool useSystemAppearance : 1 { false };
    bool viewTransitionClassesEnabled : 1 { false };
    bool viewTransitionsEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty
        && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

constexpr bool isLogicalPropertyGroupProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

constexpr bool isLogicalPropertyGroupPhysicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupPhysicalProperty);
}

constexpr bool isLogicalPropertyGroupLogicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupLogicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

WTF::TextStream& operator<<(WTF::TextStream&, CSSPropertyID);

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

